#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_OrderedComponent : BaseTest 
	{

		private BOL.OrderedComponent _tstOC;
		private Guid _tstOCGuid;
		private Guid _bloodUnitGuid;
		
		private DataTable _dtOrderedComponents;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();

			if (this.RefreshData)
			{
                //hack due to so much other manual OC inserting
                UnitTestUtil.RunSQL("update orderedcomponent set SpecimenRequiredIndicator = (select SpecimenRequiredIndicator from ComponentClassParameter where orderedcomponent.ComponentClassId = ComponentClassParameter.ComponentClassId AND orderedcomponent.divisioncode = ComponentClassParameter.DivisionCode)");
				//string sSQL = "SELECT TOP 1 * FROM OrderedComponent WHERE CprsOrderNumber IS NOT NULL AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' ORDER BY LastUpdateDate desc";
                //DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, false);
                //if (dtTemp.Rows.Count == 0)
                //{
					Hashtable guidMap = DataCreator.CreateCrossmatchedBloodUnitTestData();
					Guid unitGuid = (Guid)guidMap["bloodUnitGuid"];
					Guid ocGuid = (Guid)guidMap["orderedComponentGuid"];
					Guid ouGuid = (Guid)guidMap["orderedUnitGuid"];

					DataCreator.CreateQCdRack();
					DataTable butInsert = SprocHelper.GetInsertBloodUnitTestSprocTable2(Guid.NewGuid(), unitGuid, 102, "C", ouGuid, ocGuid);
					new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertBloodUnitTest.StoredProcName, butInsert);

					//DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);
                //}


			
				this._dtOrderedComponents = DAL.OrderedComponent.GetComponentOrders();

				string sSQL = "SELECT TOP 1 BUT.OrderedComponentGuid,BU.BloodUnitGuid FROM BloodUnitTest BUT ";
				sSQL += "JOIN vw_BloodShipAllCurrent BU ON BU.BloodUnitGuid = BUT.BloodUnitGuid ";
				sSQL += "JOIN BloodTestType BTT ON BTT.BloodTestTypeId = BUT.BloodTestTypeId ";
				sSQL += "JOIN OrderedComponent OC ON OC.OrderedComponentGuid = BUT.OrderedComponentGuid ";
				sSQL += "WHERE BUT.OrderedComponentGuid IS NOT NULL AND BUT.DivisionCode = '";
				sSQL += UnitTestConfig.TestDivisionCode + "' AND OC.OrderedComponentGuid = '" + ocGuid.ToString() + "' AND BTT.OrderableTestId = 9 ";
				sSQL += "AND OC.PatientSpecimenGuid IS NOT NULL";

				DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);
                //if (dtTemp.Rows.Count == 0)
                //{
                //    Hashtable guidMap = DataCreator.CreateCrossmatchedBloodUnitTestData();
                //    Guid unitGuid = (Guid)guidMap["bloodUnitGuid"];
                //    Guid ocGuid = (Guid)guidMap["orderedComponentGuid"];
                //    Guid ouGuid = (Guid)guidMap["orderedUnitGuid"];

                //    DataCreator.CreateQCdRack();
                //    DataTable butInsert = SprocHelper.GetInsertBloodUnitTestSprocTable2(Guid.NewGuid(), unitGuid, 102, "C", ouGuid, ocGuid);
                //    new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertBloodUnitTest.StoredProcName, butInsert);

                //    dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);
                //}

				_tstOCGuid = (Guid)dtTemp.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid];
				_bloodUnitGuid = (Guid)dtTemp.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

				this.RefreshData = false;
			}

			if (_dtOrderedComponents.Rows.Count > 0)
			{
				if (_dtOrderedComponents.Rows[0].IsNull(Common.VbecsTables.OrderedComponent.LabOrderNumber))
					_dtOrderedComponents.Rows[0][Common.VbecsTables.OrderedComponent.LabOrderNumber] = "1234567";

				_tstOC = new BOL.OrderedComponent(_dtOrderedComponents.Rows[0]);
			}
			else
			{
				Guid patientGuid = (Guid)UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 PatientGuid FROM Patient")["PatientGuid"];

				DataRow dataRow = _dtOrderedComponents.NewRow();

				// Have to default these or the setter blows up
				dataRow["OrderReceivedDateTime"] = DateTime.UtcNow;
                dataRow["CprsOrderNumber"] = DataCreator.GetNewCprsOrderNumber();
				dataRow["ComponentClassId"] = 1;
				dataRow["PatientGuid"] = patientGuid;
				dataRow["RowVersion"] = new byte[8];
				dataRow[Common.VbecsTables.OrderedComponent.LabOrderNumber] = "1234567";

				_tstOC = new BOL.OrderedComponent(dataRow);
			}
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection();
		}

		[Test]
		public void OrderedComponentGuid_Pass()
		{
			System.Guid _OrderedComponentGuid;
			_OrderedComponentGuid = _tstOC.OrderedComponentGuid;
			Assert.AreEqual(_tstOC.OrderedComponentGuid,_OrderedComponentGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderedComponentGuid_Fail()
		{
		}

		[Test]
		public void TaskStatusCode_Pass()
		{
			Common.TaskStatus _TaskStatusCode;
			_TaskStatusCode = _tstOC.TaskStatusCode;
			Assert.AreEqual(_tstOC.TaskStatusCode,_TaskStatusCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TaskStatusCode_Fail()
		{
		}

		[Test]
		public void ComponentOrdered_Pass()
		{
			gov.va.med.vbecs.BOL.BloodComponentClass _ComponentOrdered;
			_ComponentOrdered = _tstOC.ComponentOrdered;
			Assert.AreEqual(_tstOC.ComponentOrdered,_ComponentOrdered);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ComponentOrdered_Fail()
		{
		}

		[Test]
		public void Quantity_Pass()
		{
			Decimal _Quantity;
			_Quantity = _tstOC.Quantity;
			Assert.AreEqual(_tstOC.Quantity,_Quantity);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Quantity_Fail()
		{
		}

		[Test]
		public void GetComponentTaskList_Pass()
		{
			DataTable dt = BOL.OrderedComponent.GetComponentTaskList(this._tstOC.OrderGroupNumber);
			if (dt.Rows.Count == 0)
			{
				dt = BOL.OrderedComponent.GetComponentTaskList(null);
			}
			Assert.IsTrue(dt.Rows.Count > 0);
		}

		[Test]
		public void GetComponentTaskList_Fail()
		{
			DataTable dt = BOL.OrderedComponent.GetComponentTaskList("Alphabits");
			Assert.IsTrue(dt.Rows.Count == 0);
		}

		[Test]
		public void GetComponentOrders_Pass()
		{
			DataTable dt = BOL.OrderedComponent.GetComponentOrders();
			if (dt.Rows.Count == 0)
			{
				DataCreator.CreateNewOrder(false);
				//
				// Try, try again
				dt = BOL.OrderedComponent.GetComponentOrders();
			}
			Assert.IsTrue(dt.Rows.Count > 0);
		}

		[Test]
		public void GetComponentOrders_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "XXX";
			DataTable dt = BOL.OrderedComponent.GetComponentOrders();
			Assert.IsTrue(dt.Rows.Count == 0);
		}


		[Test]
		public void GetOrderableComponentClasses_Pass()
		{
			DataTable dt = BOL.OrderedComponent.GetOrderableComponentClasses();
			Assert.IsTrue(dt.Rows.Count > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderableComponentClasses_Fail()
		{
		}

		[Test]
		public void UpdateStatus_Pass()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual("Patient does not exist", patientGuid, Guid.NewGuid().ToString());
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenRequiredIndicator + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientSpecimenGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedComponent);

			DataTable dtOCs = DAL.OrderedComponent.GetComponentOrders();
			dtOCs.Select("OrderedComponentGuid = '" + orderedComponentGuid.ToString() + "'");
			BOL.OrderedComponent testOC = new BOL.OrderedComponent(dtOCs.Rows[0]);
			char osCode = Common.Utility.GetOrderStatusCodeFromEnum(testOC.OrderStatusCode);
			char tsCode = Common.Utility.GetTaskStatusCodeFromEnum(testOC.TaskStatusCode);
			Guid ccGuid = System.Guid.Empty;
			
			testOC.AssociateWithSpecimen(new BOL.Specimen(patientSpecimenGuid));
			//			BOL.ExceptionReport exc = new BOL.ExceptionReport();
			//			DataTable dtExceptionReport = new DataTable();
			//			exc.ExceptionData = dtExceptionReport.NewRow();

			Common.ExceptionType exceptionType = Common.ExceptionType.Emergency_issue_request;
			BOL.ExceptionReport exRep = new BOL.ExceptionReport(exceptionType, "Emergency order accepted: no specimen", Common.LogonUser.LogonUserName);
								
			exRep.GenerateExceptionEmergencyIssueOrder(testOC);
			
			//dtExceptionReport.Rows.Add(dtExceptionReport.NewRow());
			bool retValue = testOC.UpdateStatus(osCode, tsCode, Common.LogonUser.LogonUserName, ccGuid, "UpdateStatus_Pass()", true, exRep, Common.UpdateFunction.UnitTests);
			Assert.IsTrue(retValue);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void UpdateStatus_Fail()
		{
			this.RefreshData = true;
		    this.SetUp();
            this.RefreshData = true;
			char osCode = char.MinValue;
			char tsCode = char.MinValue;
			Guid ccGuid = System.Guid.NewGuid();

			bool retValue = this._tstOC.UpdateStatus(osCode, tsCode, Common.LogonUser.LogonUserName, ccGuid, "UpdateStatus_Fail()", false, null, Common.UpdateFunction.UnitTests);

		}


		[Test]
		public void GetRequiredOrders_Pass()
		{
			int requiredHours = 24;
			DateTime lastChecked = VBECSDateTime.GetDivisionCurrentDateTime().Subtract(new TimeSpan(777, 0, 0, 0, 0));
			DataTable dtRequiredOrders = BOL.OrderedComponent.GetRequiredOrders(UnitTestConfig.TestDivisionCode, requiredHours, lastChecked);
						
			//If we didn't crash, we're a success
			Assert.IsTrue(dtRequiredOrders.Rows.Count >= 0);
			//Assert.IsTrue("NO new orders for division " + UnitTestConfig.TestDivisionCode + " having a required date within " + requiredHours + " hours of now since " + lastChecked.ToLongDateString() + " !", dtRequiredOrders.Rows.Count > 0);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetRequiredOrders_Fail()
		{
			int requiredHours = 24;
			DateTime lastChecked = VBECSDateTime.GetDivisionCurrentDateTime().Subtract(new TimeSpan(777, 0, 0, 0, 0));
			
			Assert.IsTrue(BOL.OrderedComponent.GetRequiredOrders(string.Empty, requiredHours, lastChecked)!= null);
			Assert.IsTrue(BOL.OrderedComponent.GetRequiredOrders(null, requiredHours, lastChecked)!= null);
			Assert.IsTrue(BOL.OrderedComponent.GetRequiredOrders(UnitTestConfig.TestDivisionCode, -1, lastChecked)!= null);
			Assert.IsTrue(BOL.OrderedComponent.GetRequiredOrders(UnitTestConfig.TestDivisionCode, requiredHours, new DateTime())!= null);
		}

		[Test]
		public void GetOrdersWithSpecimenInBloodBank_Pass()
		{
			DateTime lastChecked = VBECSDateTime.GetDivisionCurrentDateTime().Subtract(new TimeSpan(777, 0, 0, 0, 0));
			DataTable dtOrdersWithSpecimens = BOL.OrderedComponent.GetOrdersWithSpecimenInBloodBank(UnitTestConfig.TestDivisionCode, lastChecked);
			
			//If we didn't crash, we're a success
			Assert.IsTrue(dtOrdersWithSpecimens.Rows.Count >= 0);
			//Assert.IsTrue("NO new orders for division " + UnitTestConfig.TestDivisionCode + " having no required specimen or specimen on file date since " + lastChecked.ToLongDateString() + " !", dtOrdersWithSpecimens.Rows.Count > 0);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetOrdersWithSpecimenInBloodBank_Fail()
		{
			DateTime lastChecked = VBECSDateTime.GetDivisionCurrentDateTime().Subtract(new TimeSpan(777, 0, 0, 0, 0));
			
			Assert.IsTrue(BOL.OrderedComponent.GetOrdersWithSpecimenInBloodBank(string.Empty, lastChecked)!= null);
			Assert.IsTrue(BOL.OrderedComponent.GetOrdersWithSpecimenInBloodBank(null, lastChecked)!= null);
			Assert.IsTrue(BOL.OrderedComponent.GetOrdersWithSpecimenInBloodBank(UnitTestConfig.TestDivisionCode, new DateTime())!= null);
		}

		[Test]
		public void GetNewOrders_Pass()
		{
			DateTime lastChecked = VBECSDateTime.GetDivisionCurrentDateTime().Subtract(new TimeSpan(777, 0, 0, 0, 0));
			DataTable dtNewOrders = BOL.OrderedComponent.GetNewOrders(UnitTestConfig.TestDivisionCode, lastChecked);
			
			//If we didn't crash, we're a success
			Assert.IsTrue(dtNewOrders.Rows.Count >= 0);
			//Assert.IsTrue("NO new orders for division " + UnitTestConfig.TestDivisionCode + " since " + lastChecked.ToLongDateString() + " !", dtNewOrders.Rows.Count > 0);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetNewOrders_Fail()
		{
			DateTime lastChecked = VBECSDateTime.GetDivisionCurrentDateTime().Subtract(new TimeSpan(777, 0, 0, 0, 0));
			
			Assert.IsTrue(BOL.OrderedComponent.GetNewOrders(string.Empty, lastChecked)!= null);
			Assert.IsTrue(BOL.OrderedComponent.GetNewOrders(null, lastChecked)!= null);
			Assert.IsTrue(BOL.OrderedComponent.GetNewOrders(UnitTestConfig.TestDivisionCode, new DateTime())!= null);
		}

		[Test]
		public void GetBloodUnitTestResultsForOrderedComponent_Pass()
		{
			System.Collections.ArrayList testResults = BOL.OrderedComponent.GetBloodUnitTestResultsForOrderedComponent(_tstOCGuid, _bloodUnitGuid);
			Assert.IsNotNull(testResults);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetBloodUnitTestResultsForOrderedComponent_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "XXX";
			System.Collections.ArrayList testResults = BOL.OrderedComponent.GetBloodUnitTestResultsForOrderedComponent(Guid.Empty, Guid.Empty);
			Assert.IsNull(testResults);
		}

		[Test]
		public void SpecimenAccessionNumber_Pass()
		{
			string specimenNumber="11111";

			_tstOC.SpecimenAccessionNumber=specimenNumber;
			
			Assert.AreEqual( this._tstOC.SpecimenAccessionNumber, specimenNumber );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenAccessionNumber_Fail()
		{
		}

		[Test]
		public void SpecimenRequiredIndicator_Pass()
		{
			Assert.IsNotNull( this._tstOC.SpecimenRequiredIndicator );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenRequiredIndicator_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			_tstOC.RecordStatusCode=Common.RecordStatusCode.Historical;
			
			Assert.AreEqual( _tstOC.RecordStatusCode, Common.RecordStatusCode.Historical );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void CPRSOrderNumber_Pass()
		{
            string cprsNumber = DataCreator.GetNewCprsOrderNumber();

			_tstOC.CPRSOrderNumber=cprsNumber;
			
			Assert.AreEqual( _tstOC.CPRSOrderNumber, cprsNumber );
		}

		[Test]
		[ExpectedException(typeof(System.Exception))]
		public void CPRSOrderNumber_Fail()
		{
			string cprsNumber=String.Empty;

			_tstOC.CPRSOrderNumber=cprsNumber;
			
			Assert.AreEqual( _tstOC.CPRSOrderNumber, cprsNumber );
		}

		[Test]
		public void RequiredDateTime_Pass()
		{
			DateTime date=DateTime.Now;

			_tstOC.RequiredDateTime=date;
			
			Assert.AreEqual( _tstOC.RequiredDateTime, date );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RequiredDateTime_Fail()
		{
		}

		[Test]
		public void OrderSpecialInstructions_Pass()
		{
			string spins="SPECIAL";

			_tstOC.OrderSpecialInstructions=spins;
			
			Assert.AreEqual( _tstOC.OrderSpecialInstructions, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderSpecialInstructions_Fail()
		{
		}

		[Test]
		public void OrderedComponentComments_Pass()
		{
			string spins="SPECIAL";

			_tstOC.OrderedComponentComments=spins;
			
			Assert.AreEqual( _tstOC.OrderedComponentComments, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderedComponentComments_Fail()
		{
		}

		[Test]
		public void OrderUrgencyCode_Pass()
		{
			string spins="R";

			_tstOC.OrderUrgencyCode=spins;
			
			Assert.AreEqual( _tstOC.OrderUrgencyCode, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderUrgencyCode_Fail()
		{
		}

		[Test]
		public void OrderUrgencyText_Pass()
		{
			string spins="R";

			_tstOC.OrderUrgencyText=spins;
			
			Assert.AreEqual( _tstOC.OrderUrgencyText, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderUrgencyText_Fail()
		{
		}

		[Test]
		public void OrderStatusCode_Pass()
		{
			_tstOC.OrderStatusCode=Common.OrderStatus.Pending;
			
			Assert.AreEqual( _tstOC.OrderStatusCode, Common.OrderStatus.Pending );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderStatusCode_Fail()
		{
		}

		[Test]
		public void OrderStatusText_Pass()
		{
			string spins="R";

			_tstOC.OrderStatusText=spins;
			
			Assert.AreEqual( _tstOC.OrderStatusText, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderStatusText_Fail()
		{
		}

		[Test]
		public void Specimen_Pass()
		{
			System.Guid specimenGuid;

			string sSQL = "SELECT TOP 1 * FROM OrderedComponent WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND PatientSpecimenGuid IS NOT NULL";

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

			specimenGuid = (System.Guid)dtTemp.Rows[0][TABLES.OrderedComponent.PatientSpecimenGuid];
			
			BOL.Specimen specimen=new Specimen(specimenGuid);

			_tstOC.AssociateWithSpecimen(specimen);
			
			Assert.AreEqual( _tstOC.GetSpecimen().SpecimenGuid, specimenGuid );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Specimen_Fail()
		{
		}

		[Test]
		public void SpecimenStatusCode_Pass()
		{
			_tstOC.SpecimenStatusCode=Common.SpecimenStatus.InBloodBank;
			
			Assert.AreEqual( _tstOC.SpecimenStatusCode, Common.SpecimenStatus.InBloodBank );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenStatusCode_Fail()
		{
		}

		[Test]
		public void SpecimenStatusText_Pass()
		{
			string spins="R";

			_tstOC.SpecimenStatusText=spins;
			
			Assert.AreEqual( _tstOC.SpecimenStatusText, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenStatusText_Fail()
		{
		}

		[Test]
		public void VBECSOrderNumber_Pass()
		{
			string spins="R";

			_tstOC.VBECSOrderNumber=spins;
			
			Assert.AreEqual( _tstOC.VBECSOrderNumber, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void VBECSOrderNumber_Fail()
		{
		}

		[Test]
		public void PreOpIndicator_Pass()
		{
			bool spins=!_tstOC.PreOpIndicator;

			_tstOC.PreOpIndicator=spins;
			
			Assert.AreEqual( _tstOC.PreOpIndicator, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PreOpIndicator_Fail()
		{
		}

		[Test]
		public void InnappropriateRequestIndicator_Pass()
		{
			bool spins=!_tstOC.InappropriateRequestIndicator;

			_tstOC.InappropriateRequestIndicator=spins;
			
			Assert.AreEqual( _tstOC.InappropriateRequestIndicator, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InnappropriateRequestIndicator_Fail()
		{
		}

		[Test]
		public void CancellationCommentGUID_Pass()
		{
			System.Guid spins=System.Guid.NewGuid();

			_tstOC.CancellationCommentGUID=spins;
			
			Assert.AreEqual( _tstOC.CancellationCommentGUID, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CancellationCommentGUID_Fail()
		{
		}

		[Test]
		public void LabOrderNumber_Pass()
		{
			Assert.IsNotNull( _tstOC.LabOrderNumber );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LabOrderNumber_Fail()
		{
		}

		[Test]
		public void LabTestId_Pass()
		{
			string spins="VALID_ID";

			_tstOC.LabTestId=spins;
			
			Assert.AreEqual( _tstOC.LabTestId, spins );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LabTestId_Fail()
		{
		}

		[Test]
		public void EmergencyOrderIndicator_Pass()
		{
			bool tstValue = (!this._tstOC.EmergencyOrderIndicator);

			this._tstOC.EmergencyOrderIndicator = tstValue;
			
			Assert.AreEqual( tstValue, this._tstOC.EmergencyOrderIndicator);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EmergencyOrderIndicator_Fail()
		{
		}

		[Test]
		public void RowVersion_Pass()
		{
			System.Byte[] rowVersion;

			string sSQL = "SELECT TOP 1 * FROM OrderedComponent WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND PatientSpecimenGuid IS NOT NULL";

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

			rowVersion = (System.Byte[])dtTemp.Rows[0][TABLES.OrderedComponent.RowVersion];
			
			_tstOC.RowVersion=rowVersion;
			
			Assert.AreEqual( _tstOC.RowVersion, rowVersion );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RowVersion_Fail()
		{
			
		}

		[Test]
		public void Ctor_Pass()
		{
			string sSQL = "SELECT TOP 1 * FROM OrderedComponent WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND PatientSpecimenGuid IS NOT NULL";

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

			BOL.OrderedComponent orderedComponent=new OrderedComponent(dtTemp.Rows[0]);
			
			Assert.IsNotNull( orderedComponent );
			Assert.AreEqual( orderedComponent.OrderedComponentGuid, (System.Guid)dtTemp.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid] );
		}

		[Test]
		[ExpectedException(typeof(System.Exception))]
		public void Ctor_Fail()
		{
			string sSQL = "SELECT TOP 1 * FROM OrderedComponent WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND PatientSpecimenGuid IS NOT NULL";

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

			BOL.OrderedComponent orderedComponent=new OrderedComponent(dtTemp.NewRow());
			
			Assert.IsNotNull( orderedComponent );
			Assert.AreEqual( orderedComponent.OrderedComponentGuid, (System.Guid)dtTemp.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid] );
		
		}

		[Test]
		public void GetOrderedComponent_Pass()
		{
			string sSQL = "SELECT TOP 1 * FROM OrderedComponent WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND PatientSpecimenGuid IS NOT NULL";

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

			DataTable dtOrderedComponent=BOL.OrderedComponent.GetOrderedComponent((System.Guid)dtTemp.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid]);
			
			Assert.IsTrue( dtOrderedComponent.Rows.Count > 0 );
		}

		[Test]
		[ExpectedException(typeof(System.ArgumentException))]
		public void GetOrderedComponent_Fail()
		{
			DataTable dtOrderedComponent=BOL.OrderedComponent.GetOrderedComponent(System.Guid.Empty);
			
			Assert.IsTrue( dtOrderedComponent.Rows.Count < 1 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAccessionByLabOrderNumber_Pass()
		{
			//Requires VISTA data via XML to be present -- not testworthy 
//			VistALinkUnitTestHarness.RequireConnection();
//
//			string sSQL = "SELECT TOP 1 * FROM OrderedComponent WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND PatientSpecimenGuid IS NOT NULL";
//
//			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);
//
//			string accession=BOL.OrderedComponent.GetAccessionByLabOrderNumber(dtTemp.Rows[0][TABLES.OrderedComponent.LabOrderNumber].ToString(), dtTemp.Rows[0][TABLES.OrderedComponent.LabTestId].ToString());
//
//			Assert.IsTrue( accession.Length > 0 );

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAccessionByLabOrderNumber_Fail()
		{
		}

		[Test]
		public void IsOrderedComponentPending_No_Params_Pass()
		{
			bool pass = BOL.OrderedComponent.IsOrderedComponentPending();

			Assert.IsNotNull( pass );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsOrderedComponentPending_No_Params_Fail()
		{
		}

		[Test]
		public void IsOrderedComponentPending_Pass()
		{
			bool pass=BOL.OrderedComponent.IsOrderedComponentPending(Common.ComponentClass.CRYO);

			Assert.IsNotNull( pass );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsOrderedComponentPending_Fail()
		{
		}

		[Test]
		public void InitializeOrderedComponentTable_Pass()
		{
			DataTable pass=BOL.OrderedComponent.InitializeOrderedComponentTable();

			Assert.IsNotNull( pass );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InitializeOrderedComponentTable_Fail()
		{
		}

		
		
		[Test]
		public void CheckIfISOnlyXMatchPossible_Pass()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual("Patient does not exist", patientGuid, Guid.NewGuid().ToString());
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            string CPRSOrderNumber = DataCreator.GetNewCprsOrderNumber();
			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderGroupNumber + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + CPRSOrderNumber + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenRequiredIndicator + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientSpecimenGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderUrgencyCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + CPRSOrderNumber + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'P',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid TRGuid = Guid.NewGuid();
			string insertTransfusionReq = "INSERT INTO PATIENTTRANSFUSIONREQUIREMENT (";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.PatientGuid + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.TransfusionRequirementText + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateDate + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateUser + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateDivisionCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.VistaConversionIndicator + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.AntibodyTypeId + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.RecordStatusCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateDate + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateUser + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateFunctionId + ")";
			insertTransfusionReq += "VALUES (";
			insertTransfusionReq += "'" + TRGuid.ToString() + "',";
			insertTransfusionReq += "'" + patientGuid.ToString() + "',";
			insertTransfusionReq += "'Anti-C',";
			insertTransfusionReq += "'AS',";
			insertTransfusionReq += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReq += "'" + Environment.UserName + "',";
			insertTransfusionReq += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertTransfusionReq += "'0',";
			insertTransfusionReq += "'5',";
			insertTransfusionReq += "'A',";  //TR entered in VBECS
			insertTransfusionReq += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReq += "'" + Environment.UserName + "',";
			insertTransfusionReq += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABS = Guid.NewGuid();
			string insertOrderedTestABS = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABS += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABS += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABS += "VALUES (";
			insertOrderedTestABS += "'" + orderedTestGuidABS.ToString() + "',";
			insertOrderedTestABS += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABS += "'3',";
			insertOrderedTestABS += "'A',";
			insertOrderedTestABS += "'P',";
            insertOrderedTestABS += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABS += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABS += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABS += "'UnitTestUser',";
			insertOrderedTestABS += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuidABS.ToString() + "',";
			insertSpecimenTest += "'52',";
			insertSpecimenTest += "'N',"; //negative ABS result
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertTransfusionReq);
			UnitTestUtil.RunSQL(insertOrderedTestABS);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtOCs = OrderedComponent.GetComponentTaskList(CPRSOrderNumber);
			DataRow[] drOCs = dtOCs.Select("OrderedComponentGuid = '" + orderedComponentGuid.ToString() + "'");
			if (drOCs.Length > 0)
			{
				BOL.OrderedComponent testOC = new BOL.OrderedComponent(drOCs[0]);

				Assert.IsTrue(testOC.CheckIfISOnlyXMatchPossible() == false);
			}

			string deleteTRs = "DELETE FROM PATIENTTRANSFUSIONREQUIREMENT WHERE PATIENTGUID = '" + patientGuid.ToString() + "'";

			UnitTestUtil.RunSQL(deleteTRs);
		}

		[Test]
		public void CheckIfISOnlyXMatchPossible_Pass2()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual("Patient does not exist", patientGuid, Guid.NewGuid().ToString());
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            string CPRSOrderNumber = DataCreator.GetNewCprsOrderNumber();
			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderGroupNumber + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + CPRSOrderNumber + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenRequiredIndicator + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientSpecimenGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderUrgencyCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + CPRSOrderNumber + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'P',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid TRGuid = Guid.NewGuid();
			string insertTransfusionReq = "INSERT INTO PATIENTTRANSFUSIONREQUIREMENT (";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.PatientGuid + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.TransfusionRequirementText + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateDate + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateUser + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateDivisionCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.VistaConversionIndicator + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.AntibodyTypeId + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.RecordStatusCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateDate + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateUser + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateFunctionId + ")";
			insertTransfusionReq += "VALUES (";
			insertTransfusionReq += "'" + TRGuid.ToString() + "',";
			insertTransfusionReq += "'" + patientGuid.ToString() + "',";
			insertTransfusionReq += "'Anti-C',";
			insertTransfusionReq += "'AS',";
			insertTransfusionReq += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReq += "'" + Environment.UserName + "',";
			insertTransfusionReq += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertTransfusionReq += "'0',";
			insertTransfusionReq += "'5',";
			insertTransfusionReq += "'C',";  //TR from conversion
			insertTransfusionReq += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReq += "'" + Environment.UserName + "',";
			insertTransfusionReq += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABS = Guid.NewGuid();
			string insertOrderedTestABS = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABS += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABS += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABS += "VALUES (";
			insertOrderedTestABS += "'" + orderedTestGuidABS.ToString() + "',";
			insertOrderedTestABS += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABS += "'3',";
			insertOrderedTestABS += "'A',";
			insertOrderedTestABS += "'P',";
            insertOrderedTestABS += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABS += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABS += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABS += "'UnitTestUser',";
			insertOrderedTestABS += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuidABS.ToString() + "',";
			insertSpecimenTest += "'52',";
			insertSpecimenTest += "'N',"; //negative ABS result
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertTransfusionReq);
			UnitTestUtil.RunSQL(insertOrderedTestABS);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtOCs = OrderedComponent.GetComponentTaskList(CPRSOrderNumber);
			DataRow[] drOCs = dtOCs.Select("OrderedComponentGuid = '" + orderedComponentGuid.ToString() + "'");
			if (drOCs.Length > 0)
			{
				BOL.OrderedComponent testOC = new BOL.OrderedComponent(drOCs[0]);

				Assert.IsTrue(testOC.CheckIfISOnlyXMatchPossible() == false);
			}

			string deleteTRs = "DELETE FROM PATIENTTRANSFUSIONREQUIREMENT WHERE PATIENTGUID = '" + patientGuid.ToString() + "'";

			UnitTestUtil.RunSQL(deleteTRs);
		}

		[Test]
		public void CheckIfISOnlyXMatchPossible_Pass3()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual("Patient does not exist", patientGuid, Guid.NewGuid().ToString());
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            string CPRSOrderNumber = DataCreator.GetNewCprsOrderNumber();
			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderGroupNumber + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + CPRSOrderNumber + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenRequiredIndicator + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientSpecimenGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderUrgencyCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + CPRSOrderNumber + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'P',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABS = Guid.NewGuid();
			string insertOrderedTestABS = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABS += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABS += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABS += "VALUES (";
			insertOrderedTestABS += "'" + orderedTestGuidABS.ToString() + "',";
			insertOrderedTestABS += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABS += "'3',";
			insertOrderedTestABS += "'A',";
			insertOrderedTestABS += "'P',";
            insertOrderedTestABS += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABS += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABS += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABS += "'UnitTestUser',";
			insertOrderedTestABS += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuidABS.ToString() + "',";
			insertSpecimenTest += "'52',";
			insertSpecimenTest += "'P',"; //positive ABS result
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedTestABS);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtOCs = OrderedComponent.GetComponentTaskList(CPRSOrderNumber);
			DataRow[] drOCs = dtOCs.Select("OrderedComponentGuid = '" + orderedComponentGuid.ToString() + "'");
			if (drOCs.Length > 0)
			{
				BOL.OrderedComponent testOC = new BOL.OrderedComponent(drOCs[0]);

				Assert.IsTrue(testOC.CheckIfISOnlyXMatchPossible() == false);
			}
		}

		[Test]
		public void CheckIfISOnlyXMatchPossible_Pass4()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual("Patient does not exist", patientGuid, Guid.NewGuid().ToString());
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            string CPRSOrderNumber = DataCreator.GetNewCprsOrderNumber();
			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderGroupNumber + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + CPRSOrderNumber + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenRequiredIndicator + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientSpecimenGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderUrgencyCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + CPRSOrderNumber + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'P',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABS = Guid.NewGuid();
			string insertOrderedTestABS = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABS += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABS += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABS += "VALUES (";
			insertOrderedTestABS += "'" + orderedTestGuidABS.ToString() + "',";
			insertOrderedTestABS += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABS += "'3',";
			insertOrderedTestABS += "'A',";
			insertOrderedTestABS += "'P',";
            insertOrderedTestABS += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABS += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABS += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABS += "'UnitTestUser',";
			insertOrderedTestABS += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuidABS.ToString() + "',";
			insertSpecimenTest += "'52',";
			insertSpecimenTest += "'N',"; //negative ABS result
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedTestABS);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtOCs = OrderedComponent.GetComponentTaskList(CPRSOrderNumber);
			DataRow[] drOCs = dtOCs.Select("OrderedComponentGuid = '" + orderedComponentGuid.ToString() + "'");
			if (drOCs.Length > 0)
			{
				BOL.OrderedComponent testOC = new BOL.OrderedComponent(drOCs[0]);

				Assert.IsTrue(testOC.CheckIfISOnlyXMatchPossible() == true);
			}
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CheckIfISOnlyXMatchPossible_Fail()
		{
		}

		[Test]
		public void GetOrderAlerts_Pass()
		{
			DataTable dtTemp=BOL.OrderedComponent.GetOrderAlerts(DateTime.Today.AddYears(-5));

			Assert.IsNotNull( dtTemp );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderAlerts_Fail()
		{
		}

		[Test]
		public void GetRecentComponentOrders_Pass()
		{
			System.Guid patientGuid;

			string sSQL = "SELECT "; 
			sSQL+="TOP 1 pt.PatientGuid "; 
			sSQL+="FROM ";
			sSQL+="		OrderedComponent oc ";
			sSQL+="JOIN ";
			sSQL+="		PatientOrder po ON oc.PatientOrderGuid=po.PatientOrderGuid ";
			sSQL+="JOIN ";
			sSQL+="		PatientTreatment pt ON pt.PatientTreatmentGuid=po.PatientTreatmentGuid ";
			sSQL+="WHERE ";
			sSQL+="		oc.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND oc.PatientSpecimenGuid IS NOT NULL";

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable( sSQL, true );

			patientGuid = (System.Guid)dtTemp.Rows[0][TABLES.PatientTreatment.PatientGuid];

			DataSet assertSet=BOL.OrderedComponent.GetRecentComponentOrders(patientGuid);
			
			Assert.IsNotNull( assertSet );
			Assert.IsTrue( assertSet.Tables.Count > 0 );
		}

		[Test]
		[ExpectedException(typeof(System.ArgumentException))]
		public void GetRecentComponentOrders_Fail()
		{
			DataSet assertSet=BOL.OrderedComponent.GetRecentComponentOrders(Guid.Empty);
			
			Assert.IsNotNull( assertSet );
			Assert.IsTrue( assertSet.Tables.Count > 0 );
		}

		[Test]
		public void GetRecentComponentOrdersCount_Pass()
		{
			System.Guid patientGuid;

			string sSQL = "SELECT "; 
			sSQL+="TOP 1 pt.PatientGuid "; 
			sSQL+="FROM ";
			sSQL+="		OrderedComponent oc ";
			sSQL+="JOIN ";
			sSQL+="		PatientOrder po ON oc.PatientOrderGuid=po.PatientOrderGuid ";
			sSQL+="JOIN ";
			sSQL+="		PatientTreatment pt ON pt.PatientTreatmentGuid=po.PatientTreatmentGuid ";
			sSQL+="WHERE ";
			sSQL+="		oc.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND oc.PatientSpecimenGuid IS NOT NULL";

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable( sSQL, true );

			patientGuid = (System.Guid)dtTemp.Rows[0][TABLES.PatientTreatment.PatientGuid];

			Assert.IsTrue(BOL.OrderedComponent.GetRecentComponentOrdersCount(patientGuid)>=0);
		}

		[Test]
		[ExpectedException(typeof(System.ArgumentException))]
		public void GetRecentComponentOrdersCount_Fail()
		{
			Assert.IsTrue(BOL.OrderedComponent.GetRecentComponentOrdersCount(Guid.Empty)==0);
		}

		[Test]
		public void GetStatus_Pass()
		{
			string sSQL = "SELECT TOP 1 * FROM OrderedComponent WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND PatientSpecimenGuid IS NOT NULL";

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

			Common.TaskStatus status=BOL.OrderedComponent.GetStatus((System.Guid)dtTemp.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid]);
			
			Assert.IsNotNull( status );
		}

		[Test]
		[ExpectedException(typeof(System.ArgumentException))]
		public void GetStatus_Fail()
		{
			Common.TaskStatus status=BOL.OrderedComponent.GetStatus(System.Guid.Empty);
			
			Assert.IsNotNull( status );
		}

		[Test]
		public void NoInappropriateReportText_Pass()
		{
			string test = "test";

			this._tstOC.NoInappropriateReportText = test;

			Assert.AreEqual( this._tstOC.NoInappropriateReportText, test );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void NoInappropriateReportText_Fail()
		{
		}

		[Test]
		public void StillActive_Pass()
		{
			StringBuilder query = new StringBuilder( "SELECT TOP 1 * FROM OrderedComponent " );
			query.Append( "JOIN PatientOrder ON OrderedComponent.PatientOrderGuid = PatientOrder.PatientOrderGuid " );
			query.Append( "JOIN PatientTreatment ON PatientOrder.PatientTreatmentGuid = PatientTreatment.PatientTreatmentGuid " );
			query.Append( "JOIN Patient ON PatientTreatment.PatientGuid = Patient.PatientGuid " );
			query.Append( "WHERE PatientOrder.OrderReceivedDatetime IS NOT NULL " );
			query.Append( "AND OrderedComponent.OrderStatusCode <> 'X'" );
			//
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( query.ToString() );
			//
			BOL.OrderedComponent oc = new BOL.OrderedComponent( dr );
			//
			Common.OrderStatus status = Common.Utility.GetOrderStatusCodeFromString
			(
				DAL.OrderedComponent.GetOrderedComponent( oc.OrderedComponentGuid ).Rows[0][TABLES.OrderedComponent.OrderStatusCode].ToString()	
			);
			//
			Assert.IsTrue( oc.StillActive );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void StillActive_Fail()
		{
		}

		[Test]
		public void GetStatusIncludingUnitsEligibleForIssue_NotStarted_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual("Patient does not exist", patientGuid, Guid.NewGuid().ToString());
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenRequiredIndicator + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);

			Common.TaskStatus status=BOL.OrderedComponent.GetStatusIncludingUnitsEligibleForIssue(orderedComponentGuid);
			
			Assert.AreEqual(status, Common.TaskStatus.NotStarted );
		}

		[Test]
		public void GetStatusIncludingUnitsEligibleForIssue_PartiallyCompleted_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual("Patient does not exist", patientGuid, Guid.NewGuid().ToString());
				return;
			}
			//
			Guid bloodUnitGuid = Guid.NewGuid();
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenRequiredIndicator + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'Z',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			string updateOrderedComponent = "UPDATE ORDEREDCOMPONENT SET SPECIMENREQUIREDINDICATOR = '1' WHERE SPECIMENREQUIREDINDICATOR IS NULL";
			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedUnit);
			UnitTestUtil.RunSQL(updateOrderedComponent);

			Common.TaskStatus status=BOL.OrderedComponent.GetStatusIncludingUnitsEligibleForIssue(orderedComponentGuid);
			
			Assert.AreEqual(status, Common.TaskStatus.PartiallyCompleted );
		}

		[Test]
		public void GetStatusIncludingUnitsEligibleForIssue_Filled_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual("Patient does not exist", patientGuid, Guid.NewGuid().ToString());
				return;
			}
			//
			Guid bloodUnitGuid = Guid.NewGuid();
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];

			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");

			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);
			string insertPatientTransfusion = "INSERT INTO PATIENTTRANSFUSION (";
			insertPatientTransfusion += TABLES.PatientTransfusion.PatientTransfusionGuid + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.PatientGuid + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.BloodUnitGuid + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.ReactionIndicator + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.OtherDifficultyIndicator + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.DssExtractSuccessIndicator + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.RecordStatusCode + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.DivisionCode + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.LastUpdateDate + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.LastUpdateUser + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.LastUpdateFunctionId + ")";
			insertPatientTransfusion += "VALUES(";
			insertPatientTransfusion += "'" + Guid.NewGuid().ToString() + "',";
			insertPatientTransfusion += "'" + patientGuid.ToString() + "',";
			insertPatientTransfusion += "'" + bloodUnitGuid.ToString() + "',";
			insertPatientTransfusion += "'" + "0',";
			insertPatientTransfusion += "'" + "0',";
			insertPatientTransfusion += "'" + "0',";
			insertPatientTransfusion += "'" + "A',";
			insertPatientTransfusion += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientTransfusion += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTransfusion += "'" + Environment.UserName + "',";
			insertPatientTransfusion += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.SpecimenRequiredIndicator + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'0',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'Z',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTransfusion);
			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedUnit);

			Common.TaskStatus status=BOL.OrderedComponent.GetStatusIncludingUnitsEligibleForIssue(orderedComponentGuid);
			
			Assert.AreEqual(status, Common.TaskStatus.Filled );
		}

		[Test]
		[ExpectedException(typeof(System.ArgumentException))]
		public void GetStatusIncludingUnitsEligibleForIssue_Fail()
		{
			Common.TaskStatus status=BOL.OrderedComponent.GetStatusIncludingUnitsEligibleForIssue(System.Guid.Empty);

			Assert.IsNotNull( status );
		}


	}
}
#endif
